/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.persistence.factories;

import java.util.List;

import javax.sql.DataSource;

import net.bluemind.backend.mail.replica.persistence.MessageBodyPurgeQueueStore;
import net.bluemind.backend.mail.repository.IMessageBodyPurgeQueueStore;
import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.repository.provider.IStandaloneFactory;

public class MessageBodyPurgeQueueStoreFactory implements IStandaloneFactory<IMessageBodyPurgeQueueStore> {
	@Override
	public Class<IMessageBodyPurgeQueueStore> factoryClass() {
		return IMessageBodyPurgeQueueStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.POSTGRESQL;
	}

	@Override
	public IMessageBodyPurgeQueueStore instance(BmContext context) throws ServerFault {
		List<DataSource> datasources = context.getAllMailboxDataSource();
		if (datasources.isEmpty()) {
			throw new ServerFault("No: server is not ready (no datasources available)");
		}
		return new MessageBodyPurgeQueueStore(datasources.getFirst());
	}
}
