/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2017
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.persistence;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

import net.bluemind.backend.mail.replica.api.MailboxReplica;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.Item;
import net.bluemind.core.jdbc.Columns;
import net.bluemind.core.jdbc.JdbcAbstractStore.EntityPopulator;
import net.bluemind.core.jdbc.JdbcAbstractStore.StatementValues;

public class MailboxReplicaColumns {

	private MailboxReplicaColumns() {
	}

	public static final Columns COLUMNS = Columns.create() //
			.col("short_name") //
			.col("parent_uid") //
			.col("name")//
			.col("last_uid")//
			.col("last_append_date")//
			.col("uid_validity")//
	;

	public static final Columns COLUMNS_UPD = Columns.create() //
			.col("short_name") //
			.col("parent_uid") //
			.col("name")//
	;

	public static EntityPopulator<MailboxReplica> populator() {
		return new EntityPopulator<MailboxReplica>() {

			@Override
			public int populate(ResultSet rs, int index, MailboxReplica value) throws SQLException {
				value.name = rs.getString(index++);
				value.parentUid = rs.getString(index++);
				value.fullName = rs.getString(index++);
				value.lastUid = rs.getLong(index++);
				value.lastAppendDate = rs.getTimestamp(index++);
				value.uidValidity = rs.getLong(index++);

				return index;
			}
		};
	}

	public static StatementValues<MailboxReplica> values(Container cont, final Item item) {
		return new StatementValues<MailboxReplica>() {

			@Override
			public int setValues(Connection con, PreparedStatement statement, int index, int currentRow,
					MailboxReplica value) throws SQLException {
				statement.setString(index++, value.name);
				statement.setString(index++, value.parentUid);
				statement.setString(index++, value.fullName);
				statement.setLong(index++, value.lastUid);
				statement.setTimestamp(index++, value.lastAppendDate == null ? new Timestamp(new Date(0).getTime())
						: Timestamp.from(value.lastAppendDate.toInstant()));
				statement.setLong(index++, value.uidValidity);
				statement.setString(index++, item.uid);
				statement.setLong(index++, cont.id);
				statement.setLong(index++, item.id);
				return index;
			}
		};
	}

	public static StatementValues<MailboxReplica> updateValues(Container container, final Item item) {
		return new StatementValues<MailboxReplica>() {

			@Override
			public int setValues(Connection con, PreparedStatement statement, int index, int currentRow,
					MailboxReplica value) throws SQLException {
				statement.setString(index++, value.name);
				statement.setString(index++, value.parentUid);
				statement.setString(index++, value.fullName);
				statement.setLong(index++, container.id);
				statement.setLong(index++, item.id);
				return index;
			}
		};
	}
}
