package net.bluemind.backend.mail.partfile;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;

public interface IPartFileStore {

	void delete(String sid, String address);

	void deleteAll(String sid);

	String save(String sid, ReadStream<Buffer> stream);

	String save(String sid, InputStream in);

	ReadStream<Buffer> get(String address);

	List<File> getAll(String sid);

	void copy(Path path, String address);
}
