<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MessageSearchResult.
 */
class MessageSearchResult  {

  /*
   * @type String
   */
  public $containerUid;

  /*
   * @type long
   */
  public $itemId;

  /*
   * @type String
   */
  public $subject;

  /*
   * @type int
   */
  public $size;

  /*
   * @type String
   */
  public $messageClass;

  /*
   * @type javautilDate
   */
  public $date;

  /*
   * @type MessageSearchResultMbox
   */
  public $from;

  /*
   * @type MessageSearchResultMbox
   */
  public $to;

  /*
   * @type boolean
   */
  public $seen;

  /*
   * @type boolean
   */
  public $flagged;

  /*
   * @type boolean
   */
  public $hasAttachment;

  /*
   * @type String
   */
  public $preview;

  /*
   * @type double
   */
  public $score;

  /*
   * @type String
   */
  public $owner;

  /*
   * Constructor
   */
  public function __construct() {
    $this->containerUid = "";
    $this->itemId = 0;
    $this->subject = "";
    $this->size = 0;
    $this->messageClass = "";
    $this->date = null;
    $this->from =   new MessageSearchResultMbox();
    $this->to =   new MessageSearchResultMbox();
    $this->seen = false;
    $this->flagged = false;
    $this->hasAttachment = false;
    $this->preview = "";
    $this->score = 0;
    $this->owner = "";
  }

  public function toMap() {
    $data = array(    
        "containerUid" => empty($this->containerUid) ? null : $this->containerUid,    
        "itemId" => empty($this->itemId) ? null : $this->itemId,    
        "subject" => empty($this->subject) ? null : $this->subject,    
        "size" => empty($this->size) ? null : $this->size,    
        "messageClass" => empty($this->messageClass) ? null : $this->messageClass,    
        "date" => empty($this->date) ? null : $this->date,    
        "from" => empty($this->from) ? null : $this->from,    
        "to" => empty($this->to) ? null : $this->to,    
        "seen" => empty($this->seen) ? null : $this->seen,    
        "flagged" => empty($this->flagged) ? null : $this->flagged,    
        "hasAttachment" => empty($this->hasAttachment) ? null : $this->hasAttachment,    
        "preview" => empty($this->preview) ? null : $this->preview,    
        "score" => empty($this->score) ? null : $this->score,    
        "owner" => empty($this->owner) ? null : $this->owner);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
