<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MessageBodyPart.
 */
class MessageBodyPart  {

  /*
   * @type String
   */
  public $mime;

  /*
   * @type Map
   */
  public $mimeParameters;

  /*
   * @type String
   */
  public $address;

  /*
   * @type String
   */
  public $encoding;

  /*
   * @type String
   */
  public $charset;

  /*
   * @type String
   */
  public $fileName;

  /*
   * @type List
   */
  public $headers;

  /*
   * @type String
   */
  public $contentId;

  /*
   * @type String
   */
  public $hash;

  /*
   * @type List
   */
  public $children;

  /*
   * @type int
   */
  public $size;

  /*
   * @type DispositionType
   */
  public $dispositionType;

  /*
   * Constructor
   */
  public function __construct() {
    $this->mime = "";
    $this->mimeParameters = array();
    $this->address = "";
    $this->encoding = "";
    $this->charset = "";
    $this->fileName = "";
    $this->headers =  array();
    $this->contentId = "";
    $this->hash = "";
    $this->children =  array();
    $this->size = 0;
  }

  public function toMap() {
    $data = array(    
        "mime" => empty($this->mime) ? null : $this->mime,    
        "mimeParameters" => empty($this->mimeParameters) ? null : $this->mimeParameters,    
        "address" => empty($this->address) ? null : $this->address,    
        "encoding" => empty($this->encoding) ? null : $this->encoding,    
        "charset" => empty($this->charset) ? null : $this->charset,    
        "fileName" => empty($this->fileName) ? null : $this->fileName,    
        "headers" => empty($this->headers) ? null : $this->headers,    
        "contentId" => empty($this->contentId) ? null : $this->contentId,    
        "hash" => empty($this->hash) ? null : $this->hash,    
        "children" => empty($this->children) ? null : $this->children,    
        "size" => empty($this->size) ? null : $this->size,    
        "dispositionType" => empty($this->dispositionType) ? null : $this->dispositionType);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
