<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MailFinderQuery.
 */
class MailFinderQuery  {

  /*
   * @type String
   */
  public $from;

  /*
   * @type String
   */
  public $subject;

  /*
   * @type String
   */
  public $messageId;

  /*
   * @type String
   */
  public $before;

  /*
   * @type String
   */
  public $after;

  /*
   * Constructor
   */
  public function __construct() {
    $this->from = "";
    $this->subject = "";
    $this->messageId = "";
    $this->before = "";
    $this->after = "";
  }

  public function toMap() {
    $data = array(    
        "from" => empty($this->from) ? null : $this->from,    
        "subject" => empty($this->subject) ? null : $this->subject,    
        "messageId" => empty($this->messageId) ? null : $this->messageId,    
        "before" => empty($this->before) ? null : $this->before,    
        "after" => empty($this->after) ? null : $this->after);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
