<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Conversation.
 */
class Conversation  {

  /*
   * @type List
   */
  public $messageRefs;

  /*
   * @type long
   */
  public $conversationId;

  /*
   * @type String
   */
  public $conversationUid;

  /*
   * Constructor
   */
  public function __construct() {
    $this->messageRefs =  array();
    $this->conversationId = 0;
    $this->conversationUid = "";
  }

  public function toMap() {
    $data = array(    
        "messageRefs" => empty($this->messageRefs) ? null : $this->messageRefs,    
        "conversationId" => empty($this->conversationId) ? null : $this->conversationId,    
        "conversationUid" => empty($this->conversationUid) ? null : $this->conversationUid);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
