/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.authentication.service.hooks;

import java.util.List;
import java.util.function.Supplier;

import com.google.common.base.Suppliers;

import net.bluemind.authentication.service.IRoleValidator;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.role.service.IInternalRoles;

public class RemoveUnsupportedRoles implements IRoleValidator {
	private final Supplier<List<String>> validRoles = Suppliers
			.memoize(ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).instance(IInternalRoles.class)
					.getAllRoles().stream().map(rd -> rd.id)::toList);

	@Override
	public boolean valid(String domain, String role) {
		return validRoles.get().contains(role);
	}

	@Override
	public List<String> supportedRoles() {
		return List.of("*");
	}
}
