/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.authentication.repository;

import java.sql.SQLException;
import java.util.List;

import net.bluemind.authentication.api.APIKey;
import net.bluemind.core.api.fault.ServerFault;

public interface IAPIKeyStore {
	void create(APIKey apikey) throws ServerFault;

	void delete(String uid) throws ServerFault;

	void deleteAll() throws ServerFault;

	List<APIKey> list() throws ServerFault;

	APIKey get(String uid) throws ServerFault;

	APIKey getBySid(String sid) throws ServerFault;

	boolean check(String userUid, String sid) throws SQLException;
}