package net.bluemind.authentication.provider;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.domain.api.Domain;
import net.bluemind.user.api.User;

public interface IAuthProvider {
	public interface IAuthContext {
		public SecurityContext getSecurityContext();

		public ItemValue<Domain> getDomain();

		public ItemValue<User> getUser();

		public String getRealUserLogin();

		public String getUserPassword();
	}

	public enum AuthResult {
		YES, EXPIRED, NO, UNKNOWN, ARCHIVED
	}

	int priority();

	/**
	 * Does implementation check user password?
	 * 
	 * @return true if plug-in check implementation use user password to define
	 *         {@link #check} result, false otherwise
	 */
	default boolean checkPassword() {
		return true;
	}

	AuthResult check(BmContext ctx, IAuthContext authContext) throws ServerFault;
}
