<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * AccessTokenInfo.
 */
class AccessTokenInfo  {

  /*
   * @type AccessTokenInfoTokenStatus
   */
  public $status;

  /*
   * @type String
   */
  public $externalAuthEndPointUrl;

  /*
   * @type String
   */
  public $internalRedirectUrl;

  /*
   * @type String
   */
  public $applicationId;

  /*
   * @type String
   */
  public $state;

  /*
   * @type String
   */
  public $codeChallenge;

  /*
   * @type String
   */
  public $codeChallengeMethod;

  /*
   * @type String
   */
  public $responseType;

  /*
   * @type String
   */
  public $scope;

  /*
   * @type String
   */
  public $url;

  /*
   * Constructor
   */
  public function __construct() {
    $this->externalAuthEndPointUrl = "";
    $this->internalRedirectUrl = "";
    $this->applicationId = "";
    $this->state = "";
    $this->codeChallenge = "";
    $this->codeChallengeMethod = "";
    $this->responseType = "";
    $this->scope = "";
    $this->url = "";
  }

  public function toMap() {
    $data = array(    
        "status" => empty($this->status) ? null : $this->status,    
        "externalAuthEndPointUrl" => empty($this->externalAuthEndPointUrl) ? null : $this->externalAuthEndPointUrl,    
        "internalRedirectUrl" => empty($this->internalRedirectUrl) ? null : $this->internalRedirectUrl,    
        "applicationId" => empty($this->applicationId) ? null : $this->applicationId,    
        "state" => empty($this->state) ? null : $this->state,    
        "codeChallenge" => empty($this->codeChallenge) ? null : $this->codeChallenge,    
        "codeChallengeMethod" => empty($this->codeChallengeMethod) ? null : $this->codeChallengeMethod,    
        "responseType" => empty($this->responseType) ? null : $this->responseType,    
        "scope" => empty($this->scope) ? null : $this->scope,    
        "url" => empty($this->url) ? null : $this->url);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
