<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * APIKey.
 */
class APIKey  {

  /*
   * @type String
   */
  public $uid;

  /*
   * @type String
   */
  public $sid;

  /*
   * @type String
   */
  public $displayName;

  /*
   * @type String
   */
  public $subject;

  /*
   * @type String
   */
  public $domainUid;

  /*
   * Constructor
   */
  public function __construct() {
    $this->uid = "";
    $this->sid = "";
    $this->displayName = "";
    $this->subject = "";
    $this->domainUid = "";
  }

  public function toMap() {
    $data = array(    
        "uid" => empty($this->uid) ? null : $this->uid,    
        "sid" => empty($this->sid) ? null : $this->sid,    
        "displayName" => empty($this->displayName) ? null : $this->displayName,    
        "subject" => empty($this->subject) ? null : $this->subject,    
        "domainUid" => empty($this->domainUid) ? null : $this->domainUid);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
