<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * LoginResponse.
 */
class LoginResponse  {

  /*
   * @type LoginResponseStatus
   */
  public $status;

  /*
   * @type String
   */
  public $message;

  /*
   * @type String
   */
  public $authKey;

  /*
   * @type String
   */
  public $latd;

  /*
   * @type AuthUser
   */
  public $authUser;

  /*
   * Constructor
   */
  public function __construct() {
    $this->message = "";
    $this->authKey = "";
    $this->latd = "";
    $this->authUser =   new AuthUser();
  }

  public function toMap() {
    $data = array(    
        "status" => empty($this->status) ? null : $this->status,    
        "message" => empty($this->message) ? null : $this->message,    
        "authKey" => empty($this->authKey) ? null : $this->authKey,    
        "latd" => empty($this->latd) ? null : $this->latd,    
        "authUser" => empty($this->authUser) ? null : $this->authUser);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
