/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.IUserAccessToken.
 */

goog.provide('net.bluemind.authentication.api.UserAccessTokenClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.IUserAccessToken API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.UserAccessTokenClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/auth/access_token';
};

goog.inherits(net.bluemind.authentication.api.UserAccessTokenClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} state
 * @param {string} code
 * @return {Object}
 */
net.bluemind.authentication.api.UserAccessTokenClient.prototype.authCodeReceived = function( state ,  code  ) {

  var postUri = "/_auth";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(state)) {
    url.getQueryData().add('state', state);
  }
  if (goog.isDefAndNotNull(code)) {
    url.getQueryData().add('code', code);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "authCodeReceived_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} external_system
 * @param {string} baseUrl
 * @return {Object}
 */
net.bluemind.authentication.api.UserAccessTokenClient.prototype.getTokenInfo = function( external_system ,  baseUrl  ) {

  var postUri = "/_info";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(external_system)) {
    url.getQueryData().add('external_system', external_system);
  }
  if (goog.isDefAndNotNull(baseUrl)) {
    url.getQueryData().add('baseUrl', baseUrl);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "getTokenInfo_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

