/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.ISudoSupport.
 */

goog.provide('net.bluemind.authentication.api.SudoSupportVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.ISudoSupport API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.SudoSupportVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/auth/sudo_support';
};

goog.inherits(net.bluemind.authentication.api.SudoSupportVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} subject
 * @return {Object}
 */
net.bluemind.authentication.api.SudoSupportVertxClient.prototype.setOwner = function( subject  ) {

  var postUri = "/_owner";

  var params = {};

  if (goog.isDefAndNotNull(subject)) {
    params['subject'] = subject;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

