/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.IInternalAPIKeys.
 */

goog.provide('net.bluemind.authentication.api.InternalAPIKeysClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.IInternalAPIKeys API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.InternalAPIKeysClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/auth/keys';
};

goog.inherits(net.bluemind.authentication.api.InternalAPIKeysClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} displayName
 * @return {Object}
 */
net.bluemind.authentication.api.InternalAPIKeysClient.prototype.create = function( displayName  ) {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(displayName)) {
    url.getQueryData().add('displayName', displayName);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.authentication.api.InternalAPIKeysClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} sid
 * @return {Object}
 */
net.bluemind.authentication.api.InternalAPIKeysClient.prototype.get = function( sid  ) {

  var postUri = "/{sid}";

  postUri = postUri.replace("{sid}", goog.string.urlEncode(sid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "get_" 
                                  + sid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.InternalAPIKeysClient.prototype.list = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "list_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} displayName
 * @param {string} sid
 * @return {Object}
 */
net.bluemind.authentication.api.InternalAPIKeysClient.prototype.put = function( displayName ,  sid  ) {

  var postUri = "/_put";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(displayName)) {
    url.getQueryData().add('displayName', displayName);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "put_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = sid;
  return this.execute(cmd, body);
};

