/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.IAuthentication.
 */

goog.provide('net.bluemind.authentication.api.AuthenticationClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.IAuthentication API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.AuthenticationClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/auth';
};

goog.inherits(net.bluemind.authentication.api.AuthenticationClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {stream} contentStream
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationClient.prototype.backchannelLogout = function( contentStream  ) {

  var postUri = "/logout/backchannel";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "backchannelLogout_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = contentStream;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationClient.prototype.getCurrentUser = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getCurrentUser_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @param {string} password
 * @param {string} origin
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationClient.prototype.login = function( login ,  password ,  origin  ) {

  var postUri = "/login";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(login)) {
    url.getQueryData().add('login', login);
  }
  if (goog.isDefAndNotNull(origin)) {
    url.getQueryData().add('origin', origin);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "login_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = password;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @param {string} password
 * @param {string} origin
 * @param {boolean} interactive
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationClient.prototype.loginWithParams = function( login ,  password ,  origin ,  interactive  ) {

  var postUri = "/loginWithParams";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(login)) {
    url.getQueryData().add('login', login);
  }
  if (goog.isDefAndNotNull(origin)) {
    url.getQueryData().add('origin', origin);
  }
  if (goog.isDefAndNotNull(interactive)) {
    url.getQueryData().add('interactive', interactive);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "loginWithParams_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = password;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationClient.prototype.logout = function() {

  var postUri = "/logout";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "logout_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationClient.prototype.ping = function() {

  var postUri = "/ping";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "ping_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationClient.prototype.su = function( login  ) {

  var postUri = "/_su";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(login)) {
    url.getQueryData().add('login', login);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "su_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @param {boolean} interactive
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationClient.prototype.suWithParams = function( login ,  interactive  ) {

  var postUri = "/_suWithParams";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(login)) {
    url.getQueryData().add('login', login);
  }
  if (goog.isDefAndNotNull(interactive)) {
    url.getQueryData().add('interactive', interactive);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "suWithParams_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @param {string} password
 * @param {string} origin
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationClient.prototype.validate = function( login ,  password ,  origin  ) {

  var postUri = "/validate";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(login)) {
    url.getQueryData().add('login', login);
  }
  if (goog.isDefAndNotNull(origin)) {
    url.getQueryData().add('origin', origin);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "validate_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = password;
  return this.execute(cmd, body);
};

