/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.IAPIKeys.
 */

goog.provide('net.bluemind.authentication.api.APIKeysVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.IAPIKeys API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.APIKeysVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/auth/keys';
};

goog.inherits(net.bluemind.authentication.api.APIKeysVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} displayName
 * @return {Object}
 */
net.bluemind.authentication.api.APIKeysVertxClient.prototype.create = function( displayName  ) {

  var postUri = "";

  var params = {};

  if (goog.isDefAndNotNull(displayName)) {
    params['displayName'] = displayName;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.authentication.api.APIKeysVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.APIKeysVertxClient.prototype.list = function() {

  var postUri = "";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} displayName
 * @param {string} sid
 * @return {Object}
 */
net.bluemind.authentication.api.APIKeysVertxClient.prototype.put = function( displayName ,  sid  ) {

  var postUri = "/_put";

  var params = {};

  if (goog.isDefAndNotNull(displayName)) {
    params['displayName'] = displayName;
  }


  var body = null;
  body = sid;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

