/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.IUserAccessToken.
 */

goog.provide('net.bluemind.authentication.api.UserAccessTokenVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.IUserAccessToken API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.UserAccessTokenVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/auth/access_token';
};

goog.inherits(net.bluemind.authentication.api.UserAccessTokenVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} state
 * @param {string} code
 * @return {Object}
 */
net.bluemind.authentication.api.UserAccessTokenVertxClient.prototype.authCodeReceived = function( state ,  code  ) {

  var postUri = "/_auth";

  var params = {};

  if (goog.isDefAndNotNull(state)) {
    params['state'] = state;
  }
  if (goog.isDefAndNotNull(code)) {
    params['code'] = code;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} external_system
 * @param {string} baseUrl
 * @return {Object}
 */
net.bluemind.authentication.api.UserAccessTokenVertxClient.prototype.getTokenInfo = function( external_system ,  baseUrl  ) {

  var postUri = "/_info";

  var params = {};

  if (goog.isDefAndNotNull(external_system)) {
    params['external_system'] = external_system;
  }
  if (goog.isDefAndNotNull(baseUrl)) {
    params['baseUrl'] = baseUrl;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

