/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.ISudoSupport.
 */

goog.provide('net.bluemind.authentication.api.SudoSupportClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.ISudoSupport API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.SudoSupportClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/auth/sudo_support';
};

goog.inherits(net.bluemind.authentication.api.SudoSupportClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} subject
 * @return {Object}
 */
net.bluemind.authentication.api.SudoSupportClient.prototype.setOwner = function( subject  ) {

  var postUri = "/_owner";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(subject)) {
    url.getQueryData().add('subject', subject);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "setOwner_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

