/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.ISecurityToken.
 */

goog.provide('net.bluemind.authentication.api.SecurityTokenVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.ISecurityToken API.
 * @param {string sessionId} sessionId
*  @param {string} sessionIdentifier
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.SecurityTokenVertxClient = function( sessionId , sessionIdentifier ) {
  this.sessionId = sessionId;
  this.base = '/auth/token/{sessionIdentifier}';
  this.sessionIdentifier_ = sessionIdentifier;
  this.base = this.base.replace('{sessionIdentifier}',goog.string.urlEncode(sessionIdentifier));
};

goog.inherits(net.bluemind.authentication.api.SecurityTokenVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} sessionIdentifier
 * @private
 */
net.bluemind.authentication.api.SecurityTokenVertxClient.prototype.sessionIdentifier_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.SecurityTokenVertxClient.prototype.destroy = function() {

  var postUri = "/_delete";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.SecurityTokenVertxClient.prototype.renew = function() {

  var postUri = "/_renew";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.SecurityTokenVertxClient.prototype.upgrade = function() {

  var postUri = "/_upgrade";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

