/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.IAuthentication.
 */

goog.provide('net.bluemind.authentication.api.AuthenticationVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.IAuthentication API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.AuthenticationVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/auth';
};

goog.inherits(net.bluemind.authentication.api.AuthenticationVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationVertxClient.prototype.getCurrentUser = function() {

  var postUri = "";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @param {string} password
 * @param {string} origin
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationVertxClient.prototype.login = function( login ,  password ,  origin  ) {

  var postUri = "/login";

  var params = {};

  if (goog.isDefAndNotNull(login)) {
    params['login'] = login;
  }
  if (goog.isDefAndNotNull(origin)) {
    params['origin'] = origin;
  }


  var body = null;
  body = password;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @param {string} password
 * @param {string} origin
 * @param {boolean} interactive
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationVertxClient.prototype.loginWithParams = function( login ,  password ,  origin ,  interactive  ) {

  var postUri = "/loginWithParams";

  var params = {};

  if (goog.isDefAndNotNull(login)) {
    params['login'] = login;
  }
  if (goog.isDefAndNotNull(origin)) {
    params['origin'] = origin;
  }
  if (goog.isDefAndNotNull(interactive)) {
    params['interactive'] = interactive;
  }


  var body = null;
  body = password;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationVertxClient.prototype.logout = function() {

  var postUri = "/logout";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationVertxClient.prototype.ping = function() {

  var postUri = "/ping";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationVertxClient.prototype.su = function( login  ) {

  var postUri = "/_su";

  var params = {};

  if (goog.isDefAndNotNull(login)) {
    params['login'] = login;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @param {boolean} interactive
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationVertxClient.prototype.suWithParams = function( login ,  interactive  ) {

  var postUri = "/_suWithParams";

  var params = {};

  if (goog.isDefAndNotNull(login)) {
    params['login'] = login;
  }
  if (goog.isDefAndNotNull(interactive)) {
    params['interactive'] = interactive;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} login
 * @param {string} password
 * @param {string} origin
 * @return {Object}
 */
net.bluemind.authentication.api.AuthenticationVertxClient.prototype.validate = function( login ,  password ,  origin  ) {

  var postUri = "/validate";

  var params = {};

  if (goog.isDefAndNotNull(login)) {
    params['login'] = login;
  }
  if (goog.isDefAndNotNull(origin)) {
    params['origin'] = origin;
  }


  var body = null;
  body = password;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

