/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.authentication.api.ISecurityToken.
 */

goog.provide('net.bluemind.authentication.api.SecurityTokenClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.authentication.api.ISecurityToken API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} sessionIdentifier
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.authentication.api.SecurityTokenClient = function(rpc, base , sessionIdentifier ) {
  goog.base(this, rpc, base);
  this.base += '/auth/token/{sessionIdentifier}';
   this.sessionIdentifier_ = sessionIdentifier;
   this.base = this.base.replace('{sessionIdentifier}',goog.string.urlEncode(sessionIdentifier));
};

goog.inherits(net.bluemind.authentication.api.SecurityTokenClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} sessionIdentifier
 * @private
 */
net.bluemind.authentication.api.SecurityTokenClient.prototype.sessionIdentifier_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.SecurityTokenClient.prototype.destroy = function() {

  var postUri = "/_delete";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "destroy_" 
                                  + this.sessionIdentifier_
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.SecurityTokenClient.prototype.renew = function() {

  var postUri = "/_renew";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "renew_" 
                                  + this.sessionIdentifier_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.authentication.api.SecurityTokenClient.prototype.upgrade = function() {

  var postUri = "/_upgrade";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "upgrade_" 
                                  + this.sessionIdentifier_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  return this.execute(cmd, body);
};

