<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * AttachedFile.
 */
class AttachedFile  {

  /*
   * @type String
   */
  public $publicUrl;

  /*
   * @type Long
   */
  public $expirationDate;

  /*
   * @type String
   */
  public $name;

  /*
   * @type String
   */
  public $cid;

  /*
   * Constructor
   */
  public function __construct() {
    $this->publicUrl = "";
    $this->expirationDate = null;
    $this->name = "";
    $this->cid = "";
  }

  public function toMap() {
    $data = array(    
        "publicUrl" => empty($this->publicUrl) ? null : $this->publicUrl,    
        "expirationDate" => empty($this->expirationDate) ? null : $this->expirationDate,    
        "name" => empty($this->name) ? null : $this->name,    
        "cid" => empty($this->cid) ? null : $this->cid);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
