/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.announcement.api.IUserAnnouncements.
 */

goog.provide('net.bluemind.announcement.api.UserAnnouncementsClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.announcement.api.IUserAnnouncements API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} userUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.announcement.api.UserAnnouncementsClient = function(rpc, base , userUid ) {
  goog.base(this, rpc, base);
  this.base += '/userannouncements/{userUid}';
   this.userUid_ = userUid;
   this.base = this.base.replace('{userUid}',goog.string.urlEncode(userUid));
};

goog.inherits(net.bluemind.announcement.api.UserAnnouncementsClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} userUid
 * @private
 */
net.bluemind.announcement.api.UserAnnouncementsClient.prototype.userUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.announcement.api.UserAnnouncementsClient.prototype.get = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "get_" 
                                  + this.userUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

