/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.announcement.api.IUserAnnouncements.
 */

goog.provide('net.bluemind.announcement.api.UserAnnouncementsVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.announcement.api.IUserAnnouncements API.
 * @param {string sessionId} sessionId
*  @param {string} userUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.announcement.api.UserAnnouncementsVertxClient = function( sessionId , userUid ) {
  this.sessionId = sessionId;
  this.base = '/userannouncements/{userUid}';
  this.userUid_ = userUid;
  this.base = this.base.replace('{userUid}',goog.string.urlEncode(userUid));
};

goog.inherits(net.bluemind.announcement.api.UserAnnouncementsVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} userUid
 * @private
 */
net.bluemind.announcement.api.UserAnnouncementsVertxClient.prototype.userUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.announcement.api.UserAnnouncementsVertxClient.prototype.get = function() {

  var postUri = "";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

