<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VCardRelated.
 */
class VCardRelated  {

  /*
   * @type String
   */
  public $spouse;

  /*
   * @type String
   */
  public $manager;

  /*
   * @type String
   */
  public $assistant;

  /*
   * Constructor
   */
  public function __construct() {
    $this->spouse = "";
    $this->manager = "";
    $this->assistant = "";
  }

  public function toMap() {
    $data = array(    
        "spouse" => empty($this->spouse) ? null : $this->spouse,    
        "manager" => empty($this->manager) ? null : $this->manager,    
        "assistant" => empty($this->assistant) ? null : $this->assistant);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
