<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VCardIdentificationName.
 */
class VCardIdentificationName extends VCardBasicAttribute {

  /*
   * @type String
   */
  public $familyNames;

  /*
   * @type String
   */
  public $givenNames;

  /*
   * @type String
   */
  public $additionalNames;

  /*
   * @type String
   */
  public $prefixes;

  /*
   * @type String
   */
  public $suffixes;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->familyNames = "";
    $this->givenNames = "";
    $this->additionalNames = "";
    $this->prefixes = "";
    $this->suffixes = "";
  }

  public function toMap() {
    $data = array(    
        "familyNames" => empty($this->familyNames) ? null : $this->familyNames,    
        "givenNames" => empty($this->givenNames) ? null : $this->givenNames,    
        "additionalNames" => empty($this->additionalNames) ? null : $this->additionalNames,    
        "prefixes" => empty($this->prefixes) ? null : $this->prefixes,    
        "suffixes" => empty($this->suffixes) ? null : $this->suffixes);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
