<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VCardInfo.
 */
class VCardInfo  {

  /*
   * @type VCardKind
   */
  public $kind;

  /*
   * @type String
   */
  public $mail;

  /*
   * @type String
   */
  public $tel;

  /*
   * @type String
   */
  public $formatedName;

  /*
   * @type List
   */
  public $categories;

  /*
   * @type int
   */
  public $memberCount;

  /*
   * @type boolean
   */
  public $photo;

  /*
   * @type String
   */
  public $source;

  /*
   * @type boolean
   */
  public $hasSecurityKey;

  /*
   * Constructor
   */
  public function __construct() {
    $this->mail = "";
    $this->tel = "";
    $this->formatedName = "";
    $this->categories =  array();
    $this->memberCount = 0;
    $this->photo = false;
    $this->source = "";
    $this->hasSecurityKey = false;
  }

  public function toMap() {
    $data = array(    
        "kind" => empty($this->kind) ? null : $this->kind,    
        "mail" => empty($this->mail) ? null : $this->mail,    
        "tel" => empty($this->tel) ? null : $this->tel,    
        "formatedName" => empty($this->formatedName) ? null : $this->formatedName,    
        "categories" => empty($this->categories) ? null : $this->categories,    
        "memberCount" => empty($this->memberCount) ? null : $this->memberCount,    
        "photo" => empty($this->photo) ? null : $this->photo,    
        "source" => empty($this->source) ? null : $this->source,    
        "hasSecurityKey" => empty($this->hasSecurityKey) ? null : $this->hasSecurityKey);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
