<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VCardCommunications.
 */
class VCardCommunications  {

  /*
   * @type List
   */
  public $tels;

  /*
   * @type List
   */
  public $emails;

  /*
   * @type List
   */
  public $impps;

  /*
   * @type List
   */
  public $langs;

  /*
   * Constructor
   */
  public function __construct() {
    $this->tels =  array();
    $this->emails =  array();
    $this->impps =  array();
    $this->langs =  array();
  }

  public function toMap() {
    $data = array(    
        "tels" => empty($this->tels) ? null : $this->tels,    
        "emails" => empty($this->emails) ? null : $this->emails,    
        "impps" => empty($this->impps) ? null : $this->impps,    
        "langs" => empty($this->langs) ? null : $this->langs);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
