/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.addressbook.api.IVCardService.
 */

goog.provide('net.bluemind.addressbook.api.VCardServiceClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.addressbook.api.IVCardService API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} containerUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.addressbook.api.VCardServiceClient = function(rpc, base , containerUid ) {
  goog.base(this, rpc, base);
  this.base += '/addressbooks/vcards/{containerUid}';
   this.containerUid_ = containerUid;
   this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.addressbook.api.VCardServiceClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.addressbook.api.VCardServiceClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.addressbook.api.VCardServiceClient.prototype.exportAll = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "exportAll_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.addressbook.api.VCardServiceClient.prototype.exportCards = function( uids  ) {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "exportCards_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = uids;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} vcard
 * @return {Object}
 */
net.bluemind.addressbook.api.VCardServiceClient.prototype.importCards = function( vcard  ) {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "importCards_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = vcard;
  return this.execute(cmd, body);
};

