/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.addressbook.api.IAddressBooks.
 */

goog.provide('net.bluemind.addressbook.api.AddressBooksClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.addressbook.api.IAddressBooks API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.addressbook.api.AddressBooksClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/addressbooks';
};

goog.inherits(net.bluemind.addressbook.api.AddressBooksClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksClient.prototype.findCertsByEmail = function( email  ) {

  var postUri = "/_findCertsByEmail";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(email)) {
    url.getQueryData().add('email', email);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "findCertsByEmail_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksClient.prototype.findUidsByEmail = function( email  ) {

  var postUri = "/_findUidsByEmail";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "findUidsByEmail_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = email;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksClient.prototype.search = function( query  ) {

  var postUri = "/_search";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "search_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

