/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.addressbook.api.IAddressBookUids.
 */

goog.provide('net.bluemind.addressbook.api.AddressBookUidsVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.addressbook.api.IAddressBookUids API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.addressbook.api.AddressBookUidsVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/addressbook/uids';
};

goog.inherits(net.bluemind.addressbook.api.AddressBookUidsVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookUidsVertxClient.prototype.getCollectedContactsUserAddressbook = function( uid  ) {

  var postUri = "/{uid}/_collected_contacts";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookUidsVertxClient.prototype.getDefaultUserAddressbook = function( uid  ) {

  var postUri = "/{uid}/_default_addressbook";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookUidsVertxClient.prototype.getUserCreatedAddressbook = function( uid  ) {

  var postUri = "/{uid}/_other_addressbook";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} domain
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookUidsVertxClient.prototype.getUserVCards = function( domain  ) {

  var postUri = "/{domain}/_vcards";

  postUri = postUri.replace("{domain}", goog.string.urlEncode(domain));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

