/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.addressbook.api.IAddressBooks.
 */

goog.provide('net.bluemind.addressbook.api.AddressBooksVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.addressbook.api.IAddressBooks API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.addressbook.api.AddressBooksVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/addressbooks';
};

goog.inherits(net.bluemind.addressbook.api.AddressBooksVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksVertxClient.prototype.findCertsByEmail = function( email  ) {

  var postUri = "/_findCertsByEmail";

  var params = {};

  if (goog.isDefAndNotNull(email)) {
    params['email'] = email;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksVertxClient.prototype.findUidsByEmail = function( email  ) {

  var postUri = "/_findUidsByEmail";

  var params = {};



  var body = null;
  body = email;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksVertxClient.prototype.search = function( query  ) {

  var postUri = "/_search";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

