/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.addressbook.api.IAddressBooksMgmt.
 */

goog.provide('net.bluemind.addressbook.api.AddressBooksMgmtVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.addressbook.api.IAddressBooksMgmt API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/mgmt/addressbooks';
};

goog.inherits(net.bluemind.addressbook.api.AddressBooksMgmtVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {number} since
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient.prototype.backup = function( containerUid ,  since  ) {

  var postUri = "/{containerUid}/_backupstream";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));
  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {Object} descriptor
 * @param {boolean} isDefault
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient.prototype.create = function( containerUid ,  descriptor ,  isDefault  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));
  var params = {};

  if (goog.isDefAndNotNull(isDefault)) {
    params['isDefault'] = isDefault;
  }


  var body = null;
  body = descriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient.prototype.delete_ = function( containerUid  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient.prototype.getComplete = function( containerUid  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient.prototype.reindex = function( containerUid  ) {

  var postUri = "/{containerUid}/_reindex";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient.prototype.reindexAll = function() {

  var postUri = "/_reindex";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} domain
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient.prototype.reindexDomain = function( domain  ) {

  var postUri = "/_reindexDomain";

  var params = {};

  if (goog.isDefAndNotNull(domain)) {
    params['domain'] = domain;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {stream} restoreStream
 * @param {boolean} reset
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient.prototype.restore = function( containerUid ,  restoreStream ,  reset  ) {

  var postUri = "/{containerUid}/_restorestream";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));
  var params = {};

  if (goog.isDefAndNotNull(reset)) {
    params['reset'] = reset;
  }


  var body = null;
  body = restoreStream;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtVertxClient.prototype.update = function( containerUid ,  descriptor  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));
  var params = {};



  var body = null;
  body = descriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

