/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.addressbook.api.IAddressBooksMgmt.
 */

goog.provide('net.bluemind.addressbook.api.AddressBooksMgmtClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.addressbook.api.IAddressBooksMgmt API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/mgmt/addressbooks';
};

goog.inherits(net.bluemind.addressbook.api.AddressBooksMgmtClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {number} since
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient.prototype.backup = function( containerUid ,  since  ) {

  var postUri = "/{containerUid}/_backupstream";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "backup_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {Object} descriptor
 * @param {boolean} isDefault
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient.prototype.create = function( containerUid ,  descriptor ,  isDefault  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(isDefault)) {
    url.getQueryData().add('isDefault', isDefault);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient.prototype.delete_ = function( containerUid  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient.prototype.getComplete = function( containerUid  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getComplete_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient.prototype.reindex = function( containerUid  ) {

  var postUri = "/{containerUid}/_reindex";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "reindex_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient.prototype.reindexAll = function() {

  var postUri = "/_reindex";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "reindexAll_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} domain
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient.prototype.reindexDomain = function( domain  ) {

  var postUri = "/_reindexDomain";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(domain)) {
    url.getQueryData().add('domain', domain);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "reindexDomain_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {stream} restoreStream
 * @param {boolean} reset
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient.prototype.restore = function( containerUid ,  restoreStream ,  reset  ) {

  var postUri = "/{containerUid}/_restorestream";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(reset)) {
    url.getQueryData().add('reset', reset);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "restore_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = restoreStream;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBooksMgmtClient.prototype.update = function( containerUid ,  descriptor  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

