/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.addressbook.api.IAddressBook.
 */

goog.provide('net.bluemind.addressbook.api.AddressBookVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.addressbook.api.IAddressBook API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.addressbook.api.AddressBookVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/addressbooks/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.addressbook.api.AddressBookVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.allUids = function() {

  var postUri = "/_all";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.changeset = function( since  ) {

  var postUri = "/_changeset";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.changesetById = function( since  ) {

  var postUri = "/_changesetById";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @param {string} destContainerUid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.copy = function( uids ,  destContainerUid  ) {

  var postUri = "/_copy/{destContainerUid}";

  postUri = postUri.replace("{destContainerUid}", goog.string.urlEncode(destContainerUid));
  var params = {};



  var body = null;
  body = uids;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} arg0
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.count = function( arg0  ) {

  var postUri = "/_count";

  var params = {};



  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} card
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.create = function( uid ,  card  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = card;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.createById = function( id ,  arg1  ) {

  var postUri = "/id/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.deleteById = function( id  ) {

  var postUri = "/id/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.deletePhoto = function( uid  ) {

  var postUri = "/{uid}/photo";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.filteredChangesetById = function( since ,  arg1  ) {

  var postUri = "/_filteredChangesetById";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}/complete";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.getCompleteById = function( id  ) {

  var postUri = "/{id}/completeById";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.getIcon = function( uid  ) {

  var postUri = "/{uid}/icon";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.getInfo = function( uid  ) {

  var postUri = "/{uid}/info";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.getPhoto = function( uid  ) {

  var postUri = "/{uid}/photo";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.getVersion = function() {

  var postUri = "/_version";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {number} arg1
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.itemChangelog = function( uid ,  arg1  ) {

  var postUri = "/{uid}/_itemchangelog";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @param {string} destContainerUid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.move = function( uids ,  destContainerUid  ) {

  var postUri = "/_move/{destContainerUid}";

  postUri = postUri.replace("{destContainerUid}", goog.string.urlEncode(destContainerUid));
  var params = {};



  var body = null;
  body = uids;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<number>} arg0
 * @param {boolean} bypassDeletedItems
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.multipleDeleteById = function( arg0 ,  bypassDeletedItems  ) {

  var postUri = "/_multipleDelete";

  var params = {};

  if (goog.isDefAndNotNull(bypassDeletedItems)) {
    params['bypassDeletedItems'] = bypassDeletedItems;
  }


  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.multipleGet = function( uids  ) {

  var postUri = "/_mget";

  var params = {};



  var body = null;
  body = uids;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<number>} arg0
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.multipleGetById = function( arg0  ) {

  var postUri = "/_mgetById";

  var params = {};



  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.reset = function() {

  var postUri = "/_reset";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.search = function( query  ) {

  var postUri = "/_search";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Array.<number>} photo
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.setPhoto = function( uid ,  photo  ) {

  var postUri = "/{uid}/photo";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = photo;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} arg0
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.sortedIds = function( arg0  ) {

  var postUri = "/_sorted";

  var params = {};



  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} arg0
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.sortedUids = function( arg0  ) {

  var postUri = "/_sorteduids";

  var params = {};



  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @param {Object} changes
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.sync = function( since ,  changes  ) {

  var postUri = "/_sync";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  body = changes;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.touch = function( uid  ) {

  var postUri = "/{uid}/_touch";

  var params = {};



  var body = null;
  body = uid;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} card
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.update = function( uid ,  card  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = card;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.updateById = function( id ,  arg1  ) {

  var postUri = "/id/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} changes
 * @return {Object}
 */
net.bluemind.addressbook.api.AddressBookVertxClient.prototype.updates = function( changes  ) {

  var postUri = "/_mupdates";

  var params = {};



  var body = null;
  body = changes;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

