/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.calendar.persistence;

import java.sql.Timestamp;
import java.util.Date;

import net.bluemind.calendar.api.internal.VEventHistory;
import net.bluemind.core.jdbc.Columns;

public class VEventHistoryColumns {

	public static final Columns cols = Columns.create() //
			.col("container_id") //
			.col("item_id") //
			.col("date_timestamp") //
			.col("action_type", "history_action_type") //
			.col("ics_uid") //
			.col("author") //
			.col("origin");

	public static VEventHistoryStore.StatementValues<VEventHistory> values() {
		return (conn, statement, index, currentRow, value) -> {
			statement.setLong(index++, value.containerId);
			statement.setLong(index++, value.itemId);
			statement.setTimestamp(index++, new Timestamp(value.date.getTime()));
			statement.setString(index++, value.actionType.name());
			statement.setString(index++, value.icsUid);
			statement.setString(index++, value.author);
			statement.setString(index++, value.origin);

			return index;
		};
	}

	public static VEventHistoryStore.EntityPopulator<VEventHistory> populator() {
		return (rs, index, value) -> {
			value.containerId = rs.getLong(index++);
			value.itemId = rs.getLong(index++);
			value.date = new Date(rs.getTimestamp(index++).toInstant().toEpochMilli());
			value.actionType = VEventHistory.HistoryActionType.valueOf(rs.getString(index++));
			value.icsUid = rs.getString(index++);
			value.author = rs.getString(index++);
			value.origin = rs.getString(index++);

			return index;
		};

	}
}
