/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.persistence;

import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import net.bluemind.calendar.api.internal.VEventHistory;
import net.bluemind.calendar.repository.IVEventHistoryStore;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.jdbc.JdbcAbstractStore;

public class VEventHistoryStore extends JdbcAbstractStore implements IVEventHistoryStore {

	private final Container container;

	public VEventHistoryStore(DataSource pool, Container container) {
		super(pool);
		this.container = container;
	}

	@Override
	public void store(VEventHistory value) throws SQLException {
		String query = "INSERT INTO t_history_calendar_vevent (" + VEventHistoryColumns.cols.names() + ") VALUES ("
				+ VEventHistoryColumns.cols.values() + ")";
		insert(query, value, VEventHistoryColumns.values());
	}

	@Override
	public void delete(long itemId) throws SQLException {
		delete("DELETE FROM t_history_calendar_vevent WHERE container_id = ? AND item_id = ?",
				new Object[] { container.id, itemId });
	}

	@Override
	public List<VEventHistory> get(long itemId) throws SQLException {
		String query = "SELECT " + VEventHistoryColumns.cols.names()
				+ " FROM t_history_calendar_vevent WHERE container_id = ? AND item_id=?";
		return select(query, rs -> new VEventHistory(), VEventHistoryColumns.populator(),
				new Object[] { container.id, itemId });
	}

	@Override
	public List<VEventHistory> all() throws SQLException {
		String query = "SELECT " + VEventHistoryColumns.cols.names()
				+ " FROM t_history_calendar_vevent WHERE container_id = ?";
		return select(query, rs -> new VEventHistory(), VEventHistoryColumns.populator(),
				new Object[] { container.id });
	}

	@Override
	public void batchInsert(List<VEventHistory> eventHistories) throws SQLException {
		if (eventHistories == null || eventHistories.isEmpty()) {
			return;
		}
		String query = "INSERT INTO t_history_calendar_vevent (" + VEventHistoryColumns.cols.names() + ") VALUES ("
				+ VEventHistoryColumns.cols.values() + ")";

		batchInsert(query, eventHistories, VEventHistoryColumns.values());
	}
}
