import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns {@link net.bluemind.webappdata.api.WebAppData} container UID
 */
export interface IWebAppDataUids {
    /**
     * Returns the {@link net.bluemind.webappdata.api.WebAppData} user container UID
     * @returns {@link net.bluemind.webappdata.api.WebAppData} user container UID
     */
    getContainerUid(userUid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class WebAppDataUidsClient extends ApiEndPoint implements IWebAppDataUids {
    constructor(apiKey: string, base?: string);
    getContainerUid(userUid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
