import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './UserSubscriptionClient.json';

export class UserSubscriptionClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/users/{domainUid}/subscriptions');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async listSubscriptions(subject, type,  __fetchOptions = {}) {
        let __path = this.base + '/{subject}';
        __path = __path.replace('{subject}', encodeURIComponent(subject));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (type != null) {
            __url.searchParams.append("type", type);
        }
		return this.__fetchContent(__url, __options);
    }
    async subscribe(subject, subscriptions,  __fetchOptions = {}) {
        let __path = this.base + '/{subject}/_subscribe';
        __path = __path.replace('{subject}', encodeURIComponent(subject));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (subscriptions != null) {
            __options.body = JSON.stringify(subscriptions);
        }
		return this.__fetchVoid(__url, __options);
    }
    async subscribers(containerUid,  __fetchOptions = {}) {
        let __path = this.base + '/_subscribers/{containerUid}';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async unsubscribe(subject, containers,  __fetchOptions = {}) {
        let __path = this.base + '/{subject}/_unsubscribe';
        __path = __path.replace('{subject}', encodeURIComponent(subject));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (containers != null) {
            __options.body = JSON.stringify(containers);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateAutomount(subject, subscriptions,  __fetchOptions = {}) {
        let __path = this.base + '/{subject}/_automount';
        __path = __path.replace('{subject}', encodeURIComponent(subject));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (subscriptions != null) {
            __options.body = JSON.stringify(subscriptions);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
