import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './VTodoClient.json';

export class VTodoClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/todolists/vtodos/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async exportAll( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', '*/*', __fetchOptions);
        return this.__fetchBlob(__url, __options);
    }
    async exportTodos(uids,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('POST', '*/*', __fetchOptions);
        if (uids != null) {
            __options.body = JSON.stringify(uids);
        }
        return this.__fetchBlob(__url, __options);
    }
    async importIcs(ics,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (ics != null) {
            __options.body = JSON.stringify(ics);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
