import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './TodoListsMgmtClient.json';

export class TodoListsMgmtClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/mgmt/todolists');
    }
    async create(containerUid, descriptor, isDefault,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (isDefault != null) {
            __url.searchParams.append("isDefault", isDefault);
        }
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    async getComplete(containerUid,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async reindex(containerUid,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}/_reindex';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async reindexAll( __fetchOptions = {}) {
        let __path = this.base + '/_reindex';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async update(containerUid, descriptor,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
