import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './LdapImportClient.json';

export class LdapImportClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/ldapimport');
    }
    async fullSync(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_fullsync';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async testParameters(hostname, protocol, allCertificate, basedn, logindn, password, userfilter, groupfilter,  __fetchOptions = {}) {
        let __path = this.base + '/_testparameters';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (hostname != null) {
            __url.searchParams.append("hostname", hostname);
        }
        if (protocol != null) {
            __url.searchParams.append("protocol", protocol);
        }
        if (allCertificate != null) {
            __url.searchParams.append("allCertificate", allCertificate);
        }
        if (basedn != null) {
            __url.searchParams.append("basedn", basedn);
        }
        if (logindn != null) {
            __url.searchParams.append("logindn", logindn);
        }
        if (password != null) {
            __url.searchParams.append("password", password);
        }
        if (userfilter != null) {
            __url.searchParams.append("userfilter", userfilter);
        }
        if (groupfilter != null) {
            __url.searchParams.append("groupfilter", groupfilter);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
