
import { SystemConf } from "./SystemConf"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ISystemConfiguration {
    /**
     * Get server configuration
     * @returns configuration values
     */
    getValues( __fetchOptions?: RequestOptions): Promise<SystemConf>;
    updateMutableValues(values?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class SystemConfigurationClient extends ApiEndPoint implements ISystemConfiguration {
    constructor(apiKey: string, base?: string);
    getValues( __fetchOptions?: RequestOptions): Promise<SystemConf>;
    updateMutableValues(values?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
