import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './SecurityMgmtClient.json';

export class SecurityMgmtClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/system/security');
    }
    async approveLetsEncryptTos(uid,  __fetchOptions = {}) {
        let __path = this.base + '/lets_encrypt_tos/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async generateLetsEncrypt(certData,  __fetchOptions = {}) {
        let __path = this.base + '/lets_encrypt';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (certData != null) {
            __options.body = JSON.stringify(certData);
        }
		return this.__fetchContent(__url, __options);
    }
    async getLetsEncryptTos( __fetchOptions = {}) {
        let __path = this.base + '/lets_encrypt_tos';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async updateCertificate(certData,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (certData != null) {
            __options.body = JSON.stringify(certData);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
