import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './InstallationClient.json';

export class InstallationClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/system/installation');
    }
    async clone(sourceParams,  __fetchOptions = {}) {
        let __path = this.base + '/_clone';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (sourceParams != null) {
            __options.body = JSON.stringify(sourceParams);
        }
		return this.__fetchContent(__url, __options);
    }
    async deleteLogo( __fetchOptions = {}) {
        let __path = this.base + '/logo';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async demoteLeader( __fetchOptions = {}) {
        let __path = this.base + '/state/_demote';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getHostReport( __fetchOptions = {}) {
        let __path = this.base + '/_hostReport';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getInfos( __fetchOptions = {}) {
        let __path = this.base + '/_infos';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getLogo( __fetchOptions = {}) {
        let __path = this.base + '/logo';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getSubscriptionContacts( __fetchOptions = {}) {
        let __path = this.base + '/_subscriptionContacts';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getSubscriptionInformations( __fetchOptions = {}) {
        let __path = this.base + '/subscription';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getSubscriptionKind( __fetchOptions = {}) {
        let __path = this.base + '/subscriptionKind';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getSystemState( __fetchOptions = {}) {
        let __path = this.base + '/state';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getVersion( __fetchOptions = {}) {
        let __path = this.base + '/version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async initialize( __fetchOptions = {}) {
        let __path = this.base + '/_initialize';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async isValidProductionSubscription( __fetchOptions = {}) {
        let __path = this.base + '/subscriptionProductiveValid';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async maintenanceMode( __fetchOptions = {}) {
        let __path = this.base + '/state/_maintenance';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async markSchemaAsUpgraded( __fetchOptions = {}) {
        let __path = this.base + '/version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async ping(ip,  __fetchOptions = {}) {
        let __path = this.base + '/{ip}/ping';
        __path = __path.replace('{ip}', encodeURIComponent(ip));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async postinst( __fetchOptions = {}) {
        let __path = this.base + '/_postinst';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async promoteLeader( __fetchOptions = {}) {
        let __path = this.base + '/state/_promote';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async removeSubscription( __fetchOptions = {}) {
        let __path = this.base + '/subscription';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async resetIndex(index,  __fetchOptions = {}) {
        let __path = this.base + '/{index}/_resetIndex';
        __path = __path.replace('{index}', encodeURIComponent(index));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async resetIndexes( __fetchOptions = {}) {
        let __path = this.base + '/_resetIndexes';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async runningMode( __fetchOptions = {}) {
        let __path = this.base + '/state/_maintenance';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async sendHostReport( __fetchOptions = {}) {
        let __path = this.base + '/_hostReport';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setLogo(logo,  __fetchOptions = {}) {
        let __path = this.base + '/logo';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (logo != null) {
            __options.body = JSON.stringify(logo);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setSubscriptionContacts(emails,  __fetchOptions = {}) {
        let __path = this.base + '/_subscriptionContacts';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (emails != null) {
            __options.body = JSON.stringify(emails);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateSubscription(licence,  __fetchOptions = {}) {
        let __path = this.base + '/subscription';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (licence != null) {
            __options.body = JSON.stringify(licence);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateSubscriptionVersion(version,  __fetchOptions = {}) {
        let __path = this.base + '/subscription/_version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (version != null) {
            __url.searchParams.append("version", version);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateSubscriptionWithArchive(archive,  __fetchOptions = {}) {
        let __path = this.base + '/subscription/_archive';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (archive != null) {
            __options.body = archive;
        }
		return this.__fetchVoid(__url, __options);
    }
    async upgrade( __fetchOptions = {}) {
        let __path = this.base + '/_upgrade';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async upgradeStatus( __fetchOptions = {}) {
        let __path = this.base + '/_upgrade';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
