
import { Credential } from "./Credential"; 
import { TotpCredential } from "./TotpCredential"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ICredentials {
    /**
     * Add TOTP credential to logged user
     * @param totpCredential 
     */
    addTotpCredential(totpCredential?: TotpCredential,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Get user credentials for user UID
     * @returns 
     */
    getObfuscatedUserCredentials(userUid: string,  __fetchOptions?: RequestOptions): Promise<ListResult<Credential>>;
    /**
     * Get logged user credential
     * @returns 
     */
    getSelfObfuscatedCredentials( __fetchOptions?: RequestOptions): Promise<ListResult<Credential>>;
    /**
     * Remove logged user credential from its ID
     * @param credentialId 
     */
    removeSelfCredential(credentialId: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Remove user credential from user UID and credential ID<br/>
     * 
     * Used by bm-keycloak to store credentials
     * @param credentialId 
     */
    removeUserCredential(userUid: string, credentialId: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Validate TOTP credential.
     * @param totpCredential {@link TotpCredential#displayName},
     *                       {@link TotpCredential#token} and
     *                       {@link TotpCredential#secret} (hexadecimal) must be
     *                       filled
     */
    validateTotpCredential(totpCredential?: TotpCredential,  __fetchOptions?: RequestOptions): Promise<boolean>;
}

export declare class CredentialsClient extends ApiEndPoint implements ICredentials {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    addTotpCredential(totpCredential?: TotpCredential,  __fetchOptions?: RequestOptions): Promise<string>;
    getObfuscatedUserCredentials(userUid: string,  __fetchOptions?: RequestOptions): Promise<ListResult<Credential>>;
    getSelfObfuscatedCredentials( __fetchOptions?: RequestOptions): Promise<ListResult<Credential>>;
    removeSelfCredential(credentialId: string,  __fetchOptions?: RequestOptions): Promise<void>;
    removeUserCredential(userUid: string, credentialId: string,  __fetchOptions?: RequestOptions): Promise<void>;
    validateTotpCredential(totpCredential?: TotpCredential,  __fetchOptions?: RequestOptions): Promise<boolean>;
    getMetadata(): EndPointMetadata;
}
