
export type CloneConfiguration = {
    sourceInstallationId?: string;
    uidToIpMapping?: Record<string, string>;
    sysconfOverride?: Record<string, string>;
    /**
     * Defaults to {@link Mode#FORK}
     */
    mode?: CloneConfiguration.Mode;
    cloneWorkers?: number;
    skippedContainerTypes?: Array<string>;
};
export namespace CloneConfiguration {
    export type Mode =  "TAIL" |  "PROMOTE" |  "FORK";
    export const Mode : {
        /**
         * Keeps the clone loop running. {@link IInstallation#promoteLeader()} should be
         * called on the tailing clone to trigger the promote process.
         */
        readonly TAIL: Mode,
        /**
         * Once received events from upstream install are under a certain threshold,
         * trigger {@link IInstallation#demoteLeader()} on the source installation.
         */
        readonly PROMOTE: Mode,
        /**
         * eg. to create a pre-production copy
         */
        readonly FORK: Mode
    };

}
