import { 
    ContainerChangeset,
    ItemFlagFilter,
    Ack,
    ItemValue,
    ItemVersion
} from "@bluemind/core.container.api";

import { SmimeCacertInfos } from "./SmimeCacertInfos"; 
import { SmimeCacert } from "./SmimeCacert"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * ISmimeCACerts API - admin can add CA certificates they trust. They'll be
 * trusted for all domain users. Those certificates are fetched by MailApp to
 * verify end-user certificate and check if one can be trusted.
 */
export interface ISmimeCACert {
    /**
     * List all S/MIME certificates
     * @returns All {@link SmimeCacert}
     */
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<SmimeCacert>>>;
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    create(uid: string, arg1?: SmimeCacert,  __fetchOptions?: RequestOptions): Promise<Ack>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteAll( __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    /**
     * List all S/MIME certificates with revocations
     * @returns All {@link SmimeCacertInfos}
     */
    getCacertWithRevocations( __fetchOptions?: RequestOptions): Promise<Array<SmimeCacertInfos>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SmimeCacert>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<SmimeCacert>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    multipleGet(arg0?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<SmimeCacert>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<SmimeCacert>>>;
    /**
     * Delete all {@link SmimeCacert}s of this domain
     */
    reset( __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, arg1?: SmimeCacert,  __fetchOptions?: RequestOptions): Promise<Ack>;
}

export declare class SmimeCACertClient extends ApiEndPoint implements ISmimeCACert {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<SmimeCacert>>>;
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    create(uid: string, arg1?: SmimeCacert,  __fetchOptions?: RequestOptions): Promise<Ack>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteAll( __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getCacertWithRevocations( __fetchOptions?: RequestOptions): Promise<Array<SmimeCacertInfos>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SmimeCacert>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<SmimeCacert>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    multipleGet(arg0?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<SmimeCacert>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<SmimeCacert>>>;
    reset( __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, arg1?: SmimeCacert,  __fetchOptions?: RequestOptions): Promise<Ack>;
    getMetadata(): EndPointMetadata;
}
